#version 330
#extension GL_EXT_gpu_shader4 : enable
// Raymarch anythingMod01.fsh  by   Del

//https://www.shadertoy.com/view/llyBz1
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// you can literally raymarch anything :)
float Turb(vec2 p)
{
	p*=0.25;
	p.x *= 0.7;
	float ti = iTime*0.125;
	p.y += ti;
	vec2 i = p;
	
	float c = -0.1;
	float inten = 0.15;
	float r = length(p+vec2(sin(ti),sin(ti*0.433))*2.);
	
	for (float n = 0.0; n < 4.0; n+=1.0)
	{
		float t = r-ti * (1.0 - (1.9 / (n+1.)));
		      t = r-ti/(n+0.6);
		i -= p.yx + vec2(
			cos(t*0.1 - i.x-r) + sin(t*0.1 + i.y), 
			sin(t*0.7 - i.y) + cos(t*0.4 + i.x)+r
		);
		c += 1.0/length(vec2(
			(sin(i.x+t)/inten),
			(cos(i.y+t)/inten)
			)
		);
	}
	c = smoothstep(0.0,1.0,c*0.75);
	return c * 0.3;
}


float map(vec3 p)
{
	p.x + sin(p.z+iTime)*0.5;
	p.x *= sign(p.y);	// mirror top->bottom
	float k = Turb(p.xz);
	return 3.5 -abs(p.y) - k;
}

vec3 normal(vec3 p) {
	vec2 e = vec2(.001, 0.);
	vec3 n;
	n.x = map(p + e.xyy) - map(p - e.xyy);
	n.y = map(p + e.yxy) - map(p - e.yxy);
	n.z = map(p + e.yyx) - map(p - e.yyx);
	return normalize(n);
}

vec3 render(vec2 uv)
{
	vec3 ro = vec3(sin(iTime)*0.25, cos(iTime)*0.25, iTime*0.75);
	vec3 rd = normalize(vec3(uv, .5));
	vec3 p = vec3(0.);
	float t = 0.;
	for (int i = 0; i < 80; i++)
    {
		p = ro + rd * t;
		float d = map(p);
		if (d < .001 || t > 100.) break;
		t += .5 * d;
	}
	vec3 l = ro;
	vec3 n = normal(p);
	vec3 lp = normalize(l - p);
	float diff = .5 * max(dot(lp, n), 0.);
	return vec3(diff*0.54,diff*2.8,diff*1.85) / (1. + t * t * .01);
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = (2. * gl_FragCoord.xy - iResolution.xy) / iResolution.y;
	vec3 col = render(uv);
	gl_FragColor = vec4(col, 1.);
}
